﻿using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace DelegatesAndLambdas
{
    class Program
    {
        static IEnumerable<string> GetAllFilesInDirectory(string directoryPath)
        {
            return Directory.EnumerateFiles(directoryPath, "*",
                SearchOption.AllDirectories);
        }

        static void Main(string[] args)
        {
            SideEffects();

            LocalVariable();
        }

        static void SideEffects()
        {
            // Listing 8-8. Nieprzydatne efekty uboczne w zapytaniu.
            int x = 10000;
            var bigFiles = from file in GetAllFilesInDirectory(@"c:\")
                           where new FileInfo(file).Length > x++
                           select file;
        }


        static void LocalVariable()
        {
            // Listing 8-9. Zastosowanie zmiennej lokalnej w zapytaniu.
            int minSize = 10000;
            var bigFiles = from file in GetAllFilesInDirectory(@"c:\")
                           where new FileInfo(file).Length > minSize
                           select file;
            var filesOver10k = bigFiles.ToArray();
            minSize = 100000;
            var filesOver100k = bigFiles.ToArray();
            minSize = 1000000;
            var filesOver1MB = bigFiles.ToArray();
            minSize = 10000000;
            var filesOver10MB = bigFiles.ToArray();
        }

    }
}
